//
//  MCAssistantContentView.h
//  Assistant
//
//  Created by Alykhan Jetha on 05/04/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCAssistantAbstractPane;
@class MCAssistantMatrixCell;
@class MCAssistantBackgroundView;

@interface MCAssistantContentView : NSView {
	
	NSString *firstPaneClassName;
	MCAssistantAbstractPane *firstPane;
	
	IBOutlet NSButton *nextPaneButton;
	IBOutlet NSButton *previousPaneButton;
	
	IBOutlet MCAssistantBackgroundView *backgroundView;
	IBOutlet NSMatrix *bulletsMatrix;
	IBOutlet NSTextField *longTitleField;
	
	IBOutlet NSProgressIndicator *spinningProgressIndicator;
	
	NSDictionary *configurationPropertyList;
	
	NSMutableDictionary *userInfo;
	
	id delegate;
	
}

@property (retain) NSMutableDictionary *userInfo;

- (NSButton *)nextButton;
- (NSButton *)previousButton;
- (void)toggleNextButtonEnabled;
- (void)hideNextButtonForThisStep;
- (void)validateButtons;

- (void)setFirstPaneClassName:(NSString *)classname;
- (NSString *)firstPaneClassName;

- (void)setCurrentAssistantPane:(MCAssistantAbstractPane *)pane;
- (MCAssistantAbstractPane *)currentAssistantPane;

- (IBAction)nextAssistantPane:(id)sender;
- (IBAction)previousAssistantPane:(id)sender;

- (void)displayFirstAssistantPane;
- (void)finalizeAssistant;

- (MCAssistantMatrixCell *)bulletCellWithTitle:(NSString *)cellTitle;

- (void)setConfigurationPropertyList:(NSDictionary *)plist;

/*!
 Use this to dynamically reset the bullet list. Expects an array of strings (each string could be localizable)
 */
- (void)configureBulletMatrixWithBullets:(NSArray *)bullets;


- (void)setUserInfo:(id)anObject forKey:(NSString *)aKey;
- (id)userInfoForKey:(NSString *)aKey;

@end

@interface NSObject (MCAssistantDelegateMethods)

/*
- (void)assistantContentView:(MCAssistantContentView *)assist didEncounterError:(id)error severity:(MCAssistantErrorSeverity)severity;
*/

- (void)assistantContentViewWillFinalize:(MCAssistantContentView *)assist;
- (void)assistantContentViewDidFinalize:(MCAssistantContentView *)assist;


- (NSString *)assistantRequiresFirstPaneClassName:(MCAssistantContentView *)assist;

@end
